﻿IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_RC_CREDIARIO_BLOQUEIA]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_RC_CREDIARIO_BLOQUEIA]
GO


--EXEC P_RC_CREDIARIO_BLOQUEIA
--Procedure para atualizar a  as venda do convênio com a data de fechamento ou agendamento do convênio
CREATE PROCEDURE [dbo].[P_RC_CREDIARIO_BLOQUEIA] (@IN_CD_EMP		INT = 1) AS

--Criando a tabela temporaria
CREATE TABLE #RS_BLOQ (	
					CD_EMP int,
					CD_CLI int)
					
--Criando a tabela temporaria
CREATE TABLE #RS_LIB (	
					CD_EMP int,
					CD_CLI int)					


--Inserindo os dados dos clientes na tabela temporaria
INSERT INTO #RS_BLOQ
SELECT BLOQ.CD_EMP,BLOQ.CD_CLI FROM 
(SELECT distinct
	1 AS CD_EMP,
	CD_CLI
FROM 
	V_RC_DEB_CLI_BLOQUEIO
WHERE 
	DT_LIMITE < DT_ATUAL) BLOQ INNER JOIN RC_CLI_CREDIARIO CRED ON
	BLOQ.CD_EMP=CRED.CD_EMP AND
	BLOQ.CD_CLI=CRED.CD_CLI 
WHERE 
	CRED.STS_CRED=0
	

INSERT INTO #RS_LIB
SELECT 
    LIB.CD_EMP,
    LIB.CD_CLI  FROM 
(SELECT DISTINCT
	 1 AS CD_EMP,
	 CD_CLI
FROM 
	RC_CLI_CREDIARIO CRED
WHERE CD_CLI  NOT IN (SELECT DISTINCT CD_CLI FROM V_RC_DEB_CLI_BLOQUEIO BLOQ WHERE BLOQ.DT_LIMITE<BLOQ.DT_ATUAL)) LIB INNER JOIN RC_CLI_CREDIARIO CRED ON
	LIB.CD_EMP=CRED.CD_EMP AND
	LIB.CD_CLI=CRED.CD_CLI 
WHERE
	CRED.CD_MOT_BLOQ_CLI=2



--Criando variavel que vai receber o codigo do cliente
DECLARE	@CD_EMP INT
DECLARE	@CD_CLI INT

DECLARE	@CD_EMP_LIB INT
DECLARE	@CD_CLI_LIB INT


--Criando o cursos de alteração para que possamos alterar cliente a cliente
--assim não iremos bloquear as paginas do banco de dados
--somente o registro que esta sendo alterado, assim o usuário final não vai perceber
--forma mais efeciente de atualizar os clientes sem bloquear os usuários finais
SET NOCOUNT ON
DECLARE Bloqueio CURSOR FAST_FORWARD FOR SELECT CD_EMP,CD_CLI FROM #RS_BLOQ
OPEN Bloqueio
FETCH NEXT FROM Bloqueio INTO @CD_EMP,@CD_CLI
WHILE @@FETCH_STATUS=0
	Begin
		UPDATE 
				t
		SET 
			T.STS_CRED = 1,
			T.CD_MOT_BLOQ_CLI=2,
			T.CD_USU_ALT=1
		FROM 
			RC_CLI_CREDIARIO  t
		WHERE
			t.CD_EMP = @CD_EMP
			AND t.CD_CLI = @CD_CLI
		FETCH NEXT FROM Bloqueio INTO @CD_EMP,@CD_CLI
	End

PRINT 'Concluído Bloqueio.'

--Criando o cursos de alteração para que possamos alterar cliente a cliente
--assim não iremos bloquear as paginas do banco de dados
--somente o registro que esta sendo alterado, assim o usuário final não vai perceber
--forma mais efeciente de atualizar os clientes sem bloquear os usuários finais
SET NOCOUNT ON
DECLARE Libera CURSOR FAST_FORWARD FOR SELECT CD_EMP,CD_CLI FROM #RS_LIB
OPEN Libera
FETCH NEXT FROM Libera INTO @CD_EMP_LIB,@CD_CLI_LIB
WHILE @@FETCH_STATUS=0
	Begin
		UPDATE 
				t
		SET 
			t.STS_CRED = 0,
			t.CD_MOT_BLOQ_CLI=0,
			T.CD_USU_ALT=1
		FROM 
			RC_CLI_CREDIARIO  t
		WHERE
			t.CD_EMP = @CD_EMP_LIB
			AND t.CD_CLI = @CD_CLI_LIB
		FETCH NEXT FROM Libera INTO @CD_EMP_LIB,@CD_CLI_LIB
	End

PRINT 'Concluído Liberação.'


--Fechando cursos
CLOSE Bloqueio;
--Desalocando cursos da memoria
DEALLOCATE Bloqueio;
--Apagando a tabela temporaria
DROP TABLE #RS_BLOQ;


--Fechando cursos
CLOSE Libera;
--Desalocando cursos da memoria
DEALLOCATE Libera;
--Apagando a tabela temporaria
DROP TABLE #RS_LIB;



GO


